/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Utils
**
** DESCRIPTION:	Utility functions
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef UTILS_H
#define UTILS_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwGameState.h"

#define SafeRelease(pBuffer)\
if ((pBuffer) != 0)\
{\
	delete (pBuffer);\
	(pBuffer) = 0;\
} 

/******************************************************************************\
** DESCRIPTION: 
\******************************************************************************/
inline const bool RandomChance(const float fChance)
{
	return (randN(10000) / 100.0f) < fChance;
}

/******************************************************************************\
** DESCRIPTION: 
\******************************************************************************/
inline const bool RandomChance(const int iChance)
{
	return randN(100) < iChance;
}

/******************************************************************************\
** DESCRIPTION: 
\******************************************************************************/
inline const bool IsBool(const bool bBool)
{
	return (bBool == true || bBool == false);
}

/******************************************************************************\
** DESCRIPTION: 
\******************************************************************************/
static const bool IsString(const char *psString, const int iMaxLength)
{
	int i;

	for (i = 0; i < iMaxLength; i++)
	{
		if ((psString[i] >= 0 && psString[i] < 32)/* || psString[i] > 127 */) // type char has a max value of 127  so this is a meaningless test
		{																	  // psString[i] < 0 would work for English but not for foreign characters
			// Is the string terminated?
			if (psString[i] == 0)
			{
				return true;
			}
			else
			{
				// Invalid character
				return false;
			}
		}
	}

	// String isn't terminated
	return false;
}

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/